<?php
$checkSetupGuideRequirements = checkSetupGuideRequirements(panel: 'admin');
$checkSetupGuideCheckedSteps = collect($checkSetupGuideRequirements['steps'])->filter(function ($stepItem) {
    return $stepItem['checked'];
})->toArray();
?>

<?php if($checkSetupGuideRequirements['completePercent'] < 100 && auth('admin')->user()->admin_role_id == 1): ?>
    <div class="setup-guide">
        <div
            class="setup-guide__button d-flex gap-2 justify-content-between align-items-center bg-white p-3 position-relative rounded-3 pointer shadow"
            data-bs-toggle="modal" data-bs-target="#guideModal">
            <span class="position-absolute top-0 start-100 rtl_start-0 translate-middle badge rounded-pill bg-danger border border-3 border-primary">
                <?php echo e($checkSetupGuideRequirements['totalSteps']); ?>

            </span>
            <div class="d-flex gap-2 align-items-center fw-bold text-dark">
                <img width="20" src="<?php echo e(dynamicAsset(path: 'public/assets/new/back-end/img/setup_guide.png')); ?>" alt="">
                <span class="d-none d-lg-flex"><?php echo e(translate('Setup_Guide')); ?></span>
            </div>
            <div class="border bg-light icon-btn rounded-circle text-dark d-none d-lg-flex justify-content-center align-items-center">
                <i class="fi fi-sr-angle-right mt-1 trans3"></i>
            </div>
        </div>
    </div>

    <div class="modal" id="guideModal" tabindex="-1" aria-labelledby="guideModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-end" style="--bs-modal-width: 400px">
            <div class="modal-content">
                <div class="modal-header justify-content-between p-12 p-sm-20 bg-section border-0">
                    <div class="">
                        <h3><?php echo e(translate('Setup_and_Start_your_Selling')); ?></h3>
                        <p><?php echo e(translate('Setup_and_start_managing_your_business_seamlessly')); ?></p>
                    </div>

                    <div class="progress-pie-chart" data-percent="<?php echo e($checkSetupGuideRequirements['completePercent']); ?>">
                        <div class="ppc-progress">
                            <div class="ppc-progress-fill"></div>
                        </div>
                        <div class="ppc-percents">
                            <div class="pcc-percents-wrapper">
                                <span class="fs-12 fw-bold text-dark">%</span>
                            </div>
                        </div>
                    </div>

                    <button type="button" data-bs-dismiss="modal" aria-label="Close"
                            class="btn-close position-absolute start-100 rtl_end-100 d-none d-sm-block bg-white rounded-circle opacity-100 top-0 m-2 p-2">
                    </button>
                </div>
                <div class="modal-body">

                    <?php if(count($checkSetupGuideCheckedSteps) < 2): ?>
                        <?php $__currentLoopData = $checkSetupGuideRequirements['steps']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $checkSetupGuideStepKey => $checkSetupGuideStep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!$checkSetupGuideStep['checked']): ?>
                                <div class="setup-floating-text px-2 position-absolute top-0 inset-inline-start-100 w-100 d-none d-md-block">
                                    <img src="<?php echo e(dynamicAsset(path: 'public/assets/new/back-end/img/icons/setup-guide-arrow.svg')); ?>" alt="">
                                    <h2 class="fs-28 text-white mb-0 ps-3">
                                        <?php echo e(translate('1st_setup_your')); ?> <br> <?php echo e($checkSetupGuideStep['title']); ?>

                                    </h2>
                                </div>
                                <?php break; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <div class="d-flex flex-column gap-3 overflow-y-auto" style="max-height: 340px;">
                        <?php $__currentLoopData = $checkSetupGuideRequirements['steps']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $checkSetupGuideStepKey => $checkSetupGuideStep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="p-12 p-sm-20 bg-section rounded">
                                <div class="d-flex align-items-center gap-3">
                                    <input class="form-check-input checkbox--input m-0 opacity-100" type="checkbox"
                                           value="<?php echo e($checkSetupGuideStepKey); ?>"
                                        <?php echo e($checkSetupGuideStep['checked'] ? 'checked' : ''); ?> disabled>
                                    <a href="<?php echo e($checkSetupGuideStep['route']); ?>?offcanvasShow=offcanvasSetupGuide"
                                       class="text-dark-emphasis">
                                        <?php echo e($checkSetupGuideStep['title']); ?>

                                    </a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <?php $__currentLoopData = $checkSetupGuideRequirements['steps']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $checkSetupGuideStepKey => $checkSetupGuideStep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!$checkSetupGuideStep['checked']): ?>
                            <div data-bs-dismiss="modal" aria-label="Close">
                                <a class="btn btn-primary btn-sm position-absolute end-40 bottom-20"
                                    href="<?php echo e($checkSetupGuideStep['route']); ?>?offcanvasShow=offcanvasSetupGuide">
                                    <?php echo e(translate('Lets_Start')); ?>

                                    <i class="fi fi-rr-arrow-small-right"></i>
                                </a>
                            </div>
                            <?php break; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
    </div>
<?php endif; ?>


<?php if($checkSetupGuideRequirements['completePercent'] < 100 && auth('admin')->user()->admin_role_id == 1): ?>
    <?php if(count($checkSetupGuideCheckedSteps) < 2 && !(request('offcanvasShow') && request('offcanvasShow') == 'offcanvasSetupGuide')): ?>
        <?php $__currentLoopData = $checkSetupGuideRequirements['steps']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $checkSetupGuideStepKey => $checkSetupGuideStep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(!$checkSetupGuideStep['checked']): ?>
                <script>
                    'use strict';
                    document.addEventListener("DOMContentLoaded", function() {
                        let guideModal = new bootstrap.Modal(document.getElementById('guideModal'));
                        if (guideModal) {
                            setTimeout(() => {
                                guideModal.show();
                            }, 500)
                        }
                    });
                </script>
                <?php break; ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\Crowdfunding1\E-Africal Mall org\resources\views/layouts/admin/partials/_setup-guide.blade.php ENDPATH**/ ?>